(*| 22:49 14/11/1990 *)
PROGRAM HexLoad;

USES Crt;

TYPE
  LineString= String[80];

VAR
  HexFile: TEXT;
  ComFile: FILE OF BYTE;
  FileName: LineString;
  ThisLine: LineString;
  I: INTEGER;
  Done: BOOLEAN;

FUNCTION HexNibble(S:LineString): BYTE;
VAR
  B: Byte;
BEGIN
  IF Length(S) <> 1 THEN
    B:=0
  ELSE BEGIN
    B:=ORD(S[1])-$30;
    IF B > 9 THEN B:=B-7;
  END;
  HexNibble:=B;
END;

FUNCTION HexByte(S:LineString): BYTE;
VAR
  B: Byte;
BEGIN
  IF Length(S) <> 2 THEN
    B:=0
  ELSE BEGIN
    B:=(16 * HexNibble(S[1])) + HexNibble(S[2]);
  END;
  HexByte:=B;
END;

(*FUNCTION HexWord(S:LineString): WORD;
VAR
  W: WORD;
BEGIN
  IF Length(S) <> 4 THEN
    W:=0
  ELSE BEGIN
    W:=(256 * HexByte(COPY(S,1,2))) + HexByte(Copy(S,3,2));
  END;
  HexWord:=W;
END;*)

PROCEDURE ProcessThisLine;
VAR
  Ptr,I,Len: INTEGER;
  B: BYTE;
BEGIN
  Writeln(ThisLine);
  Len:=HexByte(COPY(ThisLine,2,2));
  Ptr:=10;
  IF Len = 0 THEN
    Done:=True
  ELSE BEGIN
    FOR I:=1 TO Len DO BEGIN
      B:=HexByte(COPY(ThisLine,Ptr,2));
      Write(ComFile,B);
      Ptr:=Ptr+2;
    END;
  END;
END;  { ProcessThisLine }

BEGIN
  Write('File Name , no ext : ');
  Readln(FileName);
  FOR I:=1 TO Length(FileName) DO
    FileName[I]:=UpCase(FileName[I]);
  ASSIGN(HexFile,FileName + '.HEX');
  RESET(HexFile);
  ASSIGN(ComFile,FileName + '.COM');
  Done:=FALSE;
  REWRITE(ComFile);
    REPEAT
      READLN(HexFile,ThisLine);
      ProcessThisLine;
    UNTIL (Done OR KeyPressed);
  CLOSE(HexFile);
  CLOSE(ComFile);
END.
